﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class Student_CompetencePart_Solution : PI.FM.N000.Base.BL.DBD.BaseTable<BO.Student_CompetencePart_Solution>
    {
        #region Static factory
        private static Student_CompetencePart_Solution _factory = null;

        public static Student_CompetencePart_Solution DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Student_CompetencePart_Solution();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_Student_CompetencePart_Solution";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("StudentID", "StudentID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceID", "CompetenceID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetencePartID", "CompetencePartID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("AdvancedLevelID_Start", "AdvancedLevelID_Start"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("AdvancedLevelID_End", "AdvancedLevelID_End"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("EvaluationSheetID_Start", "EvaluationSheetID_Start"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("EvaluationSheetID_End", "EvaluationSheetID_End"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePoints", "CompetencePoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePointsByWeight", "CompetencePointsByWeight"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetenceMaxPoints", "CompetenceMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyPoints", "CaseStudyPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyMaxPoints", "CaseStudyMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Flags", "Flags"));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("IsReset", "IsReset"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10,
            CountBySearch = 11,
            RemoveBySearch = 12,
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
                case (int)Commands.CountBySearch: return new Command_CountBySearch();
                case (int)Commands.RemoveBySearch: return new Command_RemoveBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Student_CompetencePart_Solution>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Student_CompetencePart_Solution.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetencePartID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("IsReset", Gemini.Core.BL.DAL.SqlTypes.Bit));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Student_CompetencePart_Solution_RestoreBySearch";
            }
        }
        class Command_CountBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Student_CompetencePart_Solution>
        {
            public Command_CountBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Student_CompetencePart_Solution.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetencePartID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("IsReset", Gemini.Core.BL.DAL.SqlTypes.Bit));
                Add(new Gemini.Core.BL.DBD.Param("Result", null, Gemini.Core.BL.DAL.SqlTypes.Int, System.Data.ParameterDirection.Output));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Student_CompetencePart_Solution_CountBySearch";
            }
        }
        class Command_RemoveBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.Student_CompetencePart_Solution>
        {
            public Command_RemoveBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.Student_CompetencePart_Solution.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetencePartID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("IsReset", Gemini.Core.BL.DAL.SqlTypes.Bit));
                Add(new Gemini.Core.BL.DBD.Param("EditDate", Gemini.Core.BL.DAL.SqlTypes.DateTime));
                Add(new Gemini.Core.BL.DBD.Param("EditUser", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_Student_CompetencePart_Solution_RemoveBySearch";
            }
        }
        #endregion
    }
}
